/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class DataTransform {
    public boolean isDay;
    public NBTTagCompound advanced;
    public NBTTagCompound ai;
    public NBTTagCompound display;
    public NBTTagCompound inv;
    public NBTTagCompound job;
    public NBTTagCompound role;
    public NBTTagCompound stats;
    public NBTTagCompound animation;
    public boolean editingModus = false;
    public boolean hasAdvanced;
    public boolean hasAi;
    public boolean hasDisplay;
    public boolean hasInv;
    public boolean hasJob;
    public boolean hasRole;
    public boolean hasStats;
    public boolean hasAnimations;
    private final EntityNPCInterface npc;

    public DataTransform(EntityNPCInterface npcIn) {
        this.npc = npcIn;
    }

    public NBTTagCompound getDisplay() {
        NBTTagCompound compound = this.npc.display.writeToNBT(new NBTTagCompound());
        if (this.npc instanceof EntityCustomNpc) {
            compound.func_74782_a("ModelData", (NBTBase)((EntityCustomNpc)this.npc).modelData.save());
        }
        return compound;
    }

    public boolean isValid() {
        return this.hasAdvanced || this.hasAi || this.hasDisplay || this.hasInv || this.hasStats || this.hasJob || this.hasRole || this.hasAnimations;
    }

    public NBTTagCompound processAdvanced(NBTTagCompound compoundAdv, NBTTagCompound compoundRole, NBTTagCompound compoundJob) {
        if (this.hasAdvanced) {
            compoundAdv = this.advanced;
        }
        if (this.hasRole) {
            compoundRole = this.role;
        }
        if (this.hasJob) {
            compoundJob = this.job;
        }
        Set names = compoundRole.func_150296_c();
        for (String name : names) {
            compoundAdv.func_74782_a(name, compoundRole.func_74781_a(name));
        }
        names = compoundJob.func_150296_c();
        for (String name : names) {
            compoundAdv.func_74782_a(name, compoundJob.func_74781_a(name));
        }
        return compoundAdv;
    }

    public void readOptions(NBTTagCompound compound) {
        boolean hadDisplay = this.hasDisplay;
        boolean hadAI = this.hasAi;
        boolean hadAdvanced = this.hasAdvanced;
        boolean hadInv = this.hasInv;
        boolean hadStats = this.hasStats;
        boolean hadRole = this.hasRole;
        boolean hadJob = this.hasJob;
        boolean hadAnimations = this.hasAnimations;
        this.hasDisplay = compound.func_74767_n("TransformHasDisplay");
        this.hasAi = compound.func_74767_n("TransformHasAI");
        this.hasAdvanced = compound.func_74767_n("TransformHasAdvanced");
        this.hasInv = compound.func_74767_n("TransformHasInv");
        this.hasStats = compound.func_74767_n("TransformHasStats");
        this.hasRole = compound.func_74767_n("TransformHasRole");
        this.hasJob = compound.func_74767_n("TransformHasJob");
        this.editingModus = compound.func_74767_n("TransformEditingModus");
        this.hasAnimations = compound.func_74767_n("TransformHasAnimations");
        if (this.hasDisplay && !hadDisplay) {
            this.display = this.getDisplay();
        }
        if (this.hasAi && !hadAI) {
            this.ai = this.npc.ais.writeToNBT(new NBTTagCompound());
        }
        if (this.hasStats && !hadStats) {
            this.stats = this.npc.stats.writeToNBT(new NBTTagCompound());
        }
        if (this.hasInv && !hadInv) {
            this.inv = this.npc.inventory.writeEntityToNBT(new NBTTagCompound());
        }
        if (this.hasAdvanced && !hadAdvanced) {
            this.advanced = this.npc.advanced.save(new NBTTagCompound());
        }
        if (this.hasJob && !hadJob) {
            this.job = this.npc.advanced.jobInterface.save(new NBTTagCompound());
        }
        if (this.hasRole && !hadRole) {
            this.role = this.npc.advanced.roleInterface.save(new NBTTagCompound());
        }
        if (this.hasAnimations && !hadAnimations) {
            this.animation = this.npc.animation.save(new NBTTagCompound());
        }
    }

    public void load(NBTTagCompound compound) {
        this.isDay = compound.func_74767_n("TransformIsActive");
        this.readOptions(compound);
        this.display = this.hasDisplay ? compound.func_74775_l("TransformDisplay") : this.getDisplay();
        this.ai = this.hasAi ? compound.func_74775_l("TransformAI") : this.npc.ais.writeToNBT(new NBTTagCompound());
        this.advanced = this.hasAdvanced ? compound.func_74775_l("TransformAdvanced") : this.npc.advanced.save(new NBTTagCompound());
        this.inv = this.hasInv ? compound.func_74775_l("TransformInv") : this.npc.inventory.writeEntityToNBT(new NBTTagCompound());
        this.stats = this.hasStats ? compound.func_74775_l("TransformStats") : this.npc.stats.writeToNBT(new NBTTagCompound());
        this.job = this.hasJob ? compound.func_74775_l("TransformJob") : this.npc.advanced.jobInterface.save(new NBTTagCompound());
        this.role = this.hasRole ? compound.func_74775_l("TransformRole") : this.npc.advanced.roleInterface.save(new NBTTagCompound());
        this.animation = this.hasAnimations ? compound.func_74775_l("TransformAnimations") : this.npc.animation.save(new NBTTagCompound());
    }

    public void transform(boolean isDayIn) {
        NBTTagCompound compound;
        if (this.isDay == isDayIn) {
            return;
        }
        if (this.hasDisplay) {
            compound = this.getDisplay();
            this.npc.display.readToNBT(NBTTags.NBTMerge(compound, this.display));
            if (this.npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)this.npc).modelData.load(NBTTags.NBTMerge(compound.func_74775_l("ModelData"), this.display.func_74775_l("ModelData")));
            }
            this.display = compound;
        }
        if (this.hasStats) {
            compound = this.npc.stats.writeToNBT(new NBTTagCompound());
            this.npc.stats.readToNBT(NBTTags.NBTMerge(compound, this.stats));
            this.stats = compound;
        }
        if (this.hasAdvanced || this.hasJob || this.hasRole) {
            NBTTagCompound compoundAdv = this.npc.advanced.save(new NBTTagCompound());
            NBTTagCompound compoundRole = this.npc.advanced.roleInterface.save(new NBTTagCompound());
            NBTTagCompound compoundJob = this.npc.advanced.jobInterface.save(new NBTTagCompound());
            NBTTagCompound compound2 = this.processAdvanced(compoundAdv, compoundRole, compoundJob);
            this.npc.advanced.load(compound2);
            this.npc.advanced.roleInterface.load(NBTTags.NBTMerge(compoundRole, compound2));
            this.npc.advanced.jobInterface.load(NBTTags.NBTMerge(compoundJob, compound2));
            if (this.hasAdvanced) {
                this.advanced = compoundAdv;
            }
            if (this.hasRole) {
                this.role = compoundRole;
            }
            if (this.hasJob) {
                this.job = compoundJob;
            }
        }
        if (this.hasAi) {
            compound = this.npc.ais.writeToNBT(new NBTTagCompound());
            this.npc.ais.readToNBT(NBTTags.NBTMerge(compound, this.ai));
            this.ai = compound;
            this.npc.setCurrentAnimation(this.npc.ais.animationType);
        }
        if (this.hasInv) {
            compound = this.npc.inventory.writeEntityToNBT(new NBTTagCompound());
            this.npc.inventory.readEntityFromNBT(NBTTags.NBTMerge(compound, this.inv));
            this.inv = compound;
        }
        if (this.hasAnimations) {
            compound = this.npc.animation.save(new NBTTagCompound());
            this.npc.animation.load(NBTTags.NBTMerge(compound, this.animation));
            this.animation = compound;
        }
        this.npc.updateAI = true;
        this.isDay = isDayIn;
        this.npc.updateClient = true;
    }

    public NBTTagCompound writeOptions(NBTTagCompound compound) {
        compound.func_74757_a("TransformHasDisplay", this.hasDisplay);
        compound.func_74757_a("TransformHasAI", this.hasAi);
        compound.func_74757_a("TransformHasAdvanced", this.hasAdvanced);
        compound.func_74757_a("TransformHasInv", this.hasInv);
        compound.func_74757_a("TransformHasStats", this.hasStats);
        compound.func_74757_a("TransformHasRole", this.hasRole);
        compound.func_74757_a("TransformHasJob", this.hasJob);
        compound.func_74757_a("TransformEditingModus", this.editingModus);
        compound.func_74757_a("TransformHasAnimations", this.hasAnimations);
        return compound;
    }

    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74757_a("TransformIsActive", this.isDay);
        this.writeOptions(compound);
        if (this.hasDisplay) {
            compound.func_74782_a("TransformDisplay", (NBTBase)this.display);
        }
        if (this.hasAi) {
            compound.func_74782_a("TransformAI", (NBTBase)this.ai);
        }
        if (this.hasAdvanced) {
            compound.func_74782_a("TransformAdvanced", (NBTBase)this.advanced);
        }
        if (this.hasInv) {
            compound.func_74782_a("TransformInv", (NBTBase)this.inv);
        }
        if (this.hasStats) {
            compound.func_74782_a("TransformStats", (NBTBase)this.stats);
        }
        if (this.hasRole) {
            compound.func_74782_a("TransformRole", (NBTBase)this.role);
        }
        if (this.hasJob) {
            compound.func_74782_a("TransformJob", (NBTBase)this.job);
        }
        if (this.hasAnimations) {
            compound.func_74782_a("TransformAnimations", (NBTBase)this.animation);
        }
        return compound;
    }
}

